/*global define, require */
/*jslint white: true */

/*
	TrackItem:

	This object provides a mixin for each scene track item (owned by tracks).
*/

define(["src/utils", "src/build/treeLeaf", "src/build/TimeItem", "src/build/changeNotifier", "src/build/DisplayContainerStorage", "src/build/AudioContainerStorage",
		"src/build/Puppet",  "src/build/Layer", "src/build/SdkLayer", "src/build/StageId"],
function(utils, treeLeaf, TimeItem, changeNotifier, DisplayContainerStorage, AudioContainerStorage,
		  Puppet, Layer, SdkLayer, StageId) {
	"use strict";

	var TimeItem_clone = TimeItem.prototype.clone;
	
	function TrackItem(inTrackSourcePPath, inInstanceInfo0) {
		this.TimeItem("TimeItem");
		this.DisplayContainerStorage(true, false, inTrackSourcePPath.getPPathString() + " TrackItem Display Container");
		this.AudioContainerStorage(true, false, inTrackSourcePPath.getPPathString() + " TrackItem Audio Container");
		this.StageId("TrackItem_");	// TODO: add tail of PPath here? (for debugging clarity)

		// do not modify these private members directly or notifiers won't be called correctly
		this.pTrackItem = { 
			trackSource     : inTrackSourcePPath,
			parent          : undefined,
			changeNotifiers : undefined,
			instanceInfo    : inInstanceInfo0,
			privateLayer    : null,
			puppet          : null,
			view            : null
		};
	}

	utils.mixin(TrackItem, TimeItem, DisplayContainerStorage, AudioContainerStorage, StageId,
		treeLeaf({ 
			parentLabel   : "parent", 
			getTreeInfo : function (obj) { return obj.pTrackItem; }		
		}),

		changeNotifier({
			notifiersLabel: "changeNotifiers",
			getTreeInfo: function (obj) { return obj.pTrackItem; }		
		}),

		{
			getTrackSource : function () {
				return this.pTrackItem.trackSource;
			},

			getInstanceInfo : function () {
				return this.pTrackItem.instanceInfo;
			},
	
			clone : function (clone_children, other) {
				var result = other;

				if (result) {
					// init
					TrackItem.call(result, this.pTrackItem.trackSource);
				} else {
					// alloc and init
					result = new TrackItem(this.pTrackItem.trackSource);
				}

				// clone time item state
				TimeItem_clone.call(this, clone_children, result);

				// shallow clone of privateLayer and puppet
				utils.clone(false, result.pTrackItem, this.pTrackItem);

				delete result.pTrackItem.parent;
				delete result.pTrackItem.changeNotifiers;
				result.setParent(undefined);

				if (clone_children) {
					utils.clone(true, result.pTrackItem.trackSource, this.pTrackItem.trackSource);
				}

				return result;
			},
		
			getSdkLayer : function () {
				var layer = this.pTrackItem.privateLayer;
				utils.assert(layer, "TrackItem.getSdkLayer: expected to have a layer, but found none.");
				return layer.getSdkLayer();
			},
		
			getName : function () {
				return "";
			},

			setSourcePuppet : function (puppet) {
				var ti = this.pTrackItem;
				puppet.setParent(this);
				ti.puppet = puppet;
				ti.privateLayer = new Layer(puppet, { warpHash : puppet.privateGetWarpHash(), isAttached : false });
				ti.privateLayer.setWarpWithParent(false);

				// TODO: should call setVisible, but where do I retrieve that state from?
				// ti.privateLayer.setVisible(???);
				this.getDisplayContainer().addChild(ti.privateLayer.getDisplayContainer());
			},

			setSourceLayer : function (layer) {
				var ti = this.pTrackItem;
				ti.privateLayer = layer;
				this.getDisplayContainer().addChild(ti.privateLayer.getDisplayContainer());

				// TODO: move onto layers when we remove puppet/subpuppet tree
				ti.puppet = ti.privateLayer.getPuppet();
				ti.puppet.setParent(this);
			},
		
			getSourcePuppet : function () {
				return this.pTrackItem.puppet;
			},

			displayInView : function (inView, canGenerateMesh) {
				var ti = this.pTrackItem;
				var	cView = inView.getRootDisplayContainer();
				this.attachToRootDisplayContainer(cView);					
				ti.view = inView;
				// propagate to layer
				ti.privateLayer.displayInView(canGenerateMesh);
			},

			removeFromView : function (inView) {
				var cParent0 = this.getParentDisplayContainer(),
					cTrackItem = this.getDisplayContainer();
				if (cParent0) {
					cParent0.removeChild(cTrackItem);
				}

				utils.assert(inView === this.pTrackItem.view, "removeFromView(): view not found.");
				this.pTrackItem.view = null;
			},

			getView : function () {
				return this.pTrackItem.view;
			}


		});


	return TrackItem;
});
